/*Start of mandatory lines of codes in each sketch*/
#define RX A0 // define the Receive pin (RX) to communicate with the WiFi module
#define TX A1 // define the Transmit pin (TX) to communicate with the WiFi module
#include <NeoSWSerial.h> // including the library to use the Software Serial rather than the Hardware Serial (Serial)
NeoSWSerial WiFiModule(RX, TX); //initialize the variable to use in communication with the WiFi module
/*End of mandatory lines of code*/

#define RedLedPin    11
#define GreenLedPin  10
#define BlueLedPin   9

String RedStringValue = "";
String GreenStringValue = "";
String BlueStringValue = "";

int RedValue = 0;
int GreenValue = 0;
int BlueValue = 0;

void setup() {
  // put your setup code here, to run once:
  WiFiModule.begin(19200); // begin the communication between the WiFi module and the microcontroller on the board
  pinMode(RedLedPin, OUTPUT); // configure the pin connected to the Red Led to be an output
  pinMode(GreenLedPin, OUTPUT); // configure the pin connected to the Green Led to be an output
  pinMode(BlueLedPin, OUTPUT); // configure the pin connected to the Blue Led to be an output
  Serial.begin(9600); // begin the Serial monitor for debugging
}


void loop() {
  // put your main code here, to run repeatedly:
  if (WiFiModule.available() > 0) // if the WiFi module receive data from the server
  {
    String Command = WiFiModule.readStringUntil('\n'); // read the command sent from the WiFi module to the microcontroller
    Serial.println(Command); // print the command on the Serial monitor for debugging
    if (Command.indexOf("Red=") >= 0) // if the received command contains "Red=" so we should change the Red intensity 
    {
      String RedString = Command.substring(0, Command.indexOf(',')+1); // extract the command for "Red" parameter
      RedStringValue = Command.substring(Command.indexOf('=') + 1); // extract the Red intensity string value
      RedValue = RedStringValue.toInt(); // transform the string to an integer value
      analogWrite(RedLedPin, RedValue); // generate the PWM duty cycle according to the needed intensity
      Command.replace(RedString, ""); // remove the executed command
      Serial.println(Command); // print the command on the Serial monitor for debugging
    }
    if (Command.indexOf("Green=") >= 0) // if the received command contains "Green=" so we should change the Green intensity
    {
      String GreenString = Command.substring(0, Command.indexOf(',')+1); // extract the command for "Green" parameter
      GreenStringValue = Command.substring(Command.indexOf('=') + 1); // extract the Green intensity string value 
      GreenValue = GreenStringValue.toInt(); // transform the string to an integer value
      analogWrite(GreenLedPin, GreenValue); // generate the PWM duty cycle according to the needed intensity
      Command.replace(GreenString, ""); // remove the executed command
      Serial.println(Command); // print the command on the Serial monitor for debugging
    }
    if (Command.indexOf("Blue=") >= 0) // if the received command contains "Blue=" so we should change the Blue intensity
    {
      String BlueString = Command.substring(0, Command.indexOf(',')+1); // extract the command for "Blue" parameter
      BlueStringValue = Command.substring(Command.indexOf('=') + 1); // extract the Blue intensity string value 
      BlueValue = BlueStringValue.toInt(); // transform the string to an integer value
      analogWrite(BlueLedPin, BlueValue); // generate the PWM duty cycle according to the needed intensity
      Command.replace(BlueString, ""); // remove the executed command
      Serial.println(Command); // print the command on the Serial monitor for debugging
    }
  }
}
//(for more info about indexOf function see https://www.arduino.cc/reference/en/language/variables/data-types/string/functions/indexof/)
//(for more info about substring function see https://www.arduino.cc/en/Tutorial/StringSubstring)
