/*Start of mandatory lines of codes in each sketch*/
#define RX A0 // define the Receive pin (RX) to communicate with the WiFi module
#define TX A1 // define the Transmit pin (TX) to communicate with the WiFi module
#include <NeoSWSerial.h> // including the library to use the Software Serial rather than the Hardware Serial (Serial)
NeoSWSerial WiFiModule(RX, TX); //initialize the variable to use in communication with the WiFi module
/*End of mandatory lines of code*/

#define LightSensorPin   A2
#define YellowLedPin     10

void setup() {
  // put your setup code here, to run once:
  WiFiModule.begin(19200); // begin the communication between the WiFi module and the microcontroller on the board
  pinMode(YellowLedPin, OUTPUT); // configure the pin connected to the Yellow Led to be an output
}

void loop() {
  // put your main code here, to run repeatedly:
  if (WiFiModule.available() > 0) // if the WiFi module receive data from the server
  {
    String Command = WiFiModule.readStringUntil('\n'); // read the command sent from the WiFi module to the microcontroller

    if (Command.indexOf("lamp=1") >= 0) // if the received command contains "lamp=1" turn on the LED
    {
      digitalWrite(YellowLedPin, HIGH); // turn on the LED
    }
    if (Command.indexOf("lamp=0") >= 0) // if the received command contains "lamp=0" turn it off
    {
      digitalWrite(YellowLedPin, LOW); // turn off the LED
    }
  }

  int lightIntensity; // declare an integer to read the voltage

  lightIntensity = analogRead(LightSensorPin); // read the actual converted value (between 0 and 1023)
  lightIntensity = map(lightIntensity, 0, 1023, 0, 100); // transform the scale from 0 and 1023 to 0% and 100%

  WiFiModule.println("light_intensity=" + String(lightIntensity)); // send the light intensity value to the server

  delay(3000); // wait for 3 second (3000ms = 3s)
}
