/*Start of mandatory lines of codes in each sketch*/
#define RX A0 // define the Receive pin (RX) to communicate with the WiFi module
#define TX A1 // define the Transmit pin (TX) to communicate with the WiFi module
#include <NeoSWSerial.h> // including the library to use the Software Serial rather than the Hardware Serial (Serial)
NeoSWSerial WiFiModule(RX, TX); //initialize the variable to use in communication with the WiFi module
/*End of mandatory lines of code*/

#define RedLedPin   10

void setup() {
  // put your setup code here, to run once:
  WiFiModule.begin(19200); // begin the communication between the WiFi module and the microcontroller on the board
  pinMode(RedLedPin, OUTPUT); // configure the pin connected to the Red Led to be an output
}

void loop() {
  // put your main code here, to run repeatedly:
  if (WiFiModule.available() > 0) // if the WiFi module receive data from the server
  {
    String Command = WiFiModule.readStringUntil('\n'); // read the command sent from the WiFi module to the microcontroller

    if (Command.indexOf("red_led=1") >= 0) // if the received command contains "red_led=1" turn on the LED
    {
      digitalWrite(RedLedPin, HIGH); // turn on the LED
    }
    if (Command.indexOf("red_led=0") >= 0) // if the received command contains "red_led=0" turn it off
    {
      digitalWrite(RedLedPin, LOW); // turn off the LED
    }
  }
}
//(for more info about indexOf function see https://www.arduino.cc/reference/en/language/variables/data-types/string/functions/indexof/)
