#define GreenLedPin       10
#define PotentiometerPin  A2

void setup() {
  // put your setup code here, to run once:
  pinMode(GreenLedPin, OUTPUT); // configure the Green Led pin to be an output
  Serial.begin(9600);
}

void loop() {
  // put your main code here, to run repeatedly:
  int analogValue = analogRead(PotentiometerPin); // read the actual converted value (between 0 and 1023)
  // Note the analog pin can be read without declaring it as input
  
  analogValue = map(analogValue, 0, 1023, 0, 255); // transform the scale from 0 and 1023 to 0 and 255
  // becuase the analogWrite() function take parameter from 0 (0%) to 255 (100%) of duty cycle
  Serial.println(analogValue);
  
  analogWrite(GreenLedPin, analogValue); // generate the PWM duty cycle according the needed intensity
}
