/*Start of mandatory lines of codes in each sketch*/
#define RX A0 // define the Receive pin (RX) to communicate with the WiFi module
#define TX A1 // define the Transmit pin (TX) to communicate with the WiFi module
#include <NeoSWSerial.h> // including the library to use the Software Serial rather than the Hardware Serial (Serial)
NeoSWSerial WiFiModule(RX, TX); //initialize the variable to use in communication with the WiFi module
/*End of mandatory lines of code*/

#include <SimpleDHT.h> // use the library functions in the code

#define DHTPin 4 // digital pin 4 is connected to the sensor

SimpleDHT11 dht(DHTPin); // declare the DHT11 instance

void setup() {
  // put your setup code here, to run once:
  WiFiModule.begin(19200); // begin the communication between the WiFi module and the microcontroller on the board
  delay(1500); //Wait before accessing Sensor (DHT11 sampling rate is 1Hz)
}

void loop() {
  // put your main code here, to run repeatedly:
  byte humidity; // declare the humidity variable
  byte temperature; // declare the temperature variable

  dht.read(&temperature, &humidity, NULL); // read both humudity and temperature from the sensor

  String data = "";
  data += "humidity=" + String(humidity); //example: humidity=70
  data += ","; // all parameters should be comma delimited
  data += "temperature=" + String(temperature); //example: temperature=27
  //data = "humidity=70,temperature=27"
  
  WiFiModule.println(data);// send the Humidity and Temperature values to the server 

  delay(3000);//Wait 3 seconds before accessing sensor again.
}
