/*Start of mandatory lines of codes in each sketch*/
#define RX A0 // define the Receive pin (RX) to communicate with the WiFi module
#define TX A1 // define the Transmit pin (TX) to communicate with the WiFi module
#include <NeoSWSerial.h> // including the library to use the Software Serial rather than the Hardware Serial (Serial)
NeoSWSerial WiFiModule(RX, TX); //initialize the variable to use in communication with the WiFi module
/*End of mandatory lines of code*/

#define BuzzerPin   4
#define TemperatureSensorPin A2


void setup() {
  // put your setup code here, to run once:
  WiFiModule.begin(19200); // begin the communication between the WiFi module and the microcontroller on the board
  pinMode(BuzzerPin, OUTPUT); // configure the pin connected to the Buzzer to be an output
}
void loop() {
  // put your main code here, to run repeatedly:
  float Voltage; // declare a decimal variable to store the read voltage
  int Temperature; // declare an integer variable to calculate the temperature
  Voltage = analogRead(TemperatureSensorPin) * 0.0048828125; // voltage = analog_value * (5/1024);

  Temperature = -21.231 * (Voltage - 3.765);
  // this equation is the linearized form of the temperature equation between 0 and 50 degrees (specific to the thermistor in the kit)

  WiFiModule.println("temperature=" + String(Temperature)); // send the Temperature value to the server

  delay(3000); // wait for 3 second (3000ms = 3s)

  if (WiFiModule.available() > 0) // if the WiFi module receive data from the server
  {
    String Command = WiFiModule.readStringUntil('\n'); // read the command sent from the WiFi module to the microcontroller
    if (Command.indexOf("buzzer=1") >= 0) // if the received command contains "buzzer=1" trigger on the Buzzer
    {
      digitalWrite(BuzzerPin, HIGH); // turn on the LED
    }
    if (Command.indexOf("buzzer=0") >= 0) // if the received command contains "buzzer=0" trigger it off
    {
      digitalWrite(BuzzerPin, LOW); // turn off the LED
    }
  }
}
