/*Start of mandatory lines of codes in each sketch*/
#define RX A0 // define the Receive pin (RX) to communicate with the WiFi module
#define TX A1 // define the Transmit pin (TX) to communicate with the WiFi module
#include <NeoSWSerial.h> // including the library to use the Software Serial rather than the Hardware Serial (Serial)
NeoSWSerial WiFiModule(RX, TX); //initialize the variable to use in communication with the WiFi module
/*End of mandatory lines of code*/

#define LightSensorPin   A2

void setup() {
  // put your setup code here, to run once:
  WiFiModule.begin(19200); // begin the communication between the WiFi module and the microcontroller on the board
}

void loop() {
  // put your main code here, to run repeatedly:
  int lightIntensity; // declare an integer to read the voltage
  
  lightIntensity = analogRead(LightSensorPin); // read the actual converted value (between 0 and 1023)
  lightIntensity = map(lightIntensity, 0, 1023, 0, 100); // transform the scale from 0 and 1023 to 0% and 100%
  
  WiFiModule.println("light_intensity=" + String(lightIntensity)); // send the light intensity value to the server
  
  delay(3000); // wait for 3 second (3000ms = 3s)
}
