#define Button1Pin  2
#define Button2Pin  3
#define BlueLedPin  10

void setup() {
  // Set up the pushbutton pins to be an input:
  pinMode(Button1Pin, INPUT); // configure the pin connected to the pushbutton 1 to be an input
  pinMode(Button2Pin, INPUT); // configure the pin connected to the pushbutton 2 to be an input
  pinMode(BlueLedPin, OUTPUT); // configure the pin connected to the Blue Led to be an output
}

void loop() {
  
  int Button1State, Button2State;  // variables to hold the pushbutton states
  Button1State = digitalRead(Button1Pin); // read the state of Button1 (LOW if pressed and HIGH if released)
  Button2State = digitalRead(Button2Pin); // read the state of Button2 (LOW if pressed and HIGH if released)

  if (((Button1State == LOW) || (Button2State == LOW))  // if we're pushing button 1 OR button 2
      && !                                               // AND we're NOT
      ((Button1State == LOW) && (Button2State == LOW))) // pushing button 1 AND button 2 simultaneously
                                                        // then...
  {
    digitalWrite(BlueLedPin, HIGH);  // turn the Blue LED on
  }
  else
  {
    digitalWrite(BlueLedPin, LOW);  // turn the Blue LED off
  }
}
